@extends('laravelinstaller::layouts.master-update')

@section('template_title')
    {{ __('Updater') }}
@endsection

@section('title')
    <i class="fa fa-refresh fa-fw" aria-hidden="true"></i>
    {{ __('Welcome To The Updater') }}
@endsection

@section('container')
    <div class="alert text-center">
        @if ($updateData['status'])
            <div class="content" id="updateContent">
                <strong>{{ $updateData['message'] }}</strong>
                <div class="alert alert-danger">
                    {{ __('Make sure you back up all files and the database before updating.') }}
                </div>
                <p><b>{{ __('Changelog:') }}</b></p>
                {!! $updateData['changelog'] !!}
            </div>
            <div id="updateStatus"></div>
            <div class="buttons">
                <button class="button" id="updateButton" onclick="applyUpdate()">
                    <i class="fa fa-download p-r-xs"></i>
                    {{ __('Install Update') }}
                </button>
            </div>
            <div class="buttons" id="checkUpdate" style="display: none">
                <a href="{{ url()->current() }}" class="button">{{ __('Check More Updates') }}</a>
            </div>
        @else
            {{ __('Cheers! GameUP is up to date.') }}
            <p class="paragraph text-center">
                {{ __('It looks like there are no new updates available at the moment.') }}
            </p>
            <div class="buttons">
                <a href="{{ url()->current() }}" class="button">{{ __('Check Update') }}</a>
            </div>
        @endif
    </div>
@endsection

@section('scripts')
    @if ($updateData['status'])
        <script>
            function applyUpdate() {
                const updateButton = document.getElementById('updateButton');
                const updateStatus = document.getElementById('updateStatus');
                const updateContent = document.getElementById('updateContent');
                const checkUpdate = document.getElementById('checkUpdate');

                updateContent.style.display = 'none';
                updateButton.style.display = 'none';
                updateStatus.innerText = '{{ __('Downloading update, please wait...') }}';

                fetch('{{ route('LaravelUpdater::install') }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    },
                    body: JSON.stringify({
                        update_id: '{{ $updateData['update_id'] ?? '' }}',
                        has_sql: '{{ $updateData['has_sql'] ?? '' }}',
                        version: '{{ $updateData['version'] ?? '' }}',
                    }),
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        updateStatus.innerText = data.message;
                        checkUpdate.style.display = '';
                    } else {
                        updateStatus.innerText = data.message;
                        updateButton.style.display = '';
                    }
                })
                .catch(error => {
                    updateButton.style.display = '';
                    updateStatus.innerText = '{{ __('Update failed: ') }}' + error;
                });
            }
        </script>
    @endif
@endsection